% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distanceTerminalNodes}
\alias{distanceTerminalNodes}
\title{Calculate terminal node distance for each tree and terminal}
\usage{
distanceTerminalNodes(rfObject)
}
\arguments{
\item{rfObject}{\code{ranger} object}
}
\value{
a \code{matrix} object with pairwise terminal node edge length
}
\description{
first two columns are terminal node IDs; If an ID pair do not 
appear in a tree -1 is inserted
}
\examples{
require(ranger)
rf.fit <- ranger(Species ~ ., data = iris, num.trees = 5, write.forest = TRUE)
d <- distanceTerminalNodes(rf.fit)

}
