% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFModel.R
\docType{class}
\name{RFModel}
\alias{RFModel}
\title{RandomForest Proximity}
\format{\code{\link[R6]{R6Class}} object}
\usage{
RFModel
}
\description{
This class uses the proximity matrix of the random survival forest algorithm 
as a similarity matrix (sqrt(1 - proximity matrix)) of learning and verum 
cases. By default all cases with at least one missing values are dropped 
from learning, calculating the distance matrix, and searching for similar
cases.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments, and Examples} sections.
}

\section{Methods}{

\describe{
  \item{\code{new(formula, ...)}}{This method is used to create an
  object of this class \code{RFModel}. Formula for analysis has to be 
  provided. Further parameters for the ranger call can be provided here.}
  \item{\code{fit(dtData)}}{Fits the RandomForest model.}
  \item{\code{set_dist(method)}}{Set the proximity measure, 'Depth' (Default)
  and 'Proximity' are allowed.}
  \item{...}{See \link{CBRBase} class.}
  }
}

\references{
Englund and Verikas. A novel approach to estimate proximity in a random 
forest: An exploratory study.
}
\keyword{datasets}
