% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{model}
\alias{model}
\title{Generates \code{\link{model.class}} objects.}
\usage{
model(code, X, Yexp, model = "model1", opt.emul = list(p = 1, n.emul = 100,
  type = "matern5_2", binf = 0, bsup = 1, DOE = NULL),
  opt.disc = list(kernel.type = NULL))
}
\arguments{
\item{code}{the computational code (function of X and theta)}

\item{X}{the matrix of the forced variables}

\item{Yexp}{the vector of the experiments}

\item{model}{string of the model chosen ("model1","model2","model3","model4")
by default "model1" is choosen. See details for precisions.}

\item{opt.emul}{is an option list containing characteristics about emulation option. \itemize{
\item{\strong{p}}{ the number of parameter in the model (defaul value 1)}
\item{\strong{n.emul}}{ the number of points for contituing the Design Of Experiments (DOE) (default value 100)}
\item{\strong{type}}{ type of the chosen kernel (value by default "matern5_2") from \code{\link{km}} function}
\item{\strong{binf}{ the lower bound of the parameter vector (default value 0)}}
\item{\strong{bsup}{ the upper bound of the parameter vector (default value 1)}}
\item{\strong{DOE}{ design of experiments for the surrogate (default value NULL). If NULL the DOE is automatically
generated as a maximin LHS}}
}}

\item{opt.disc}{is an option list containing characteristics on the discrepancy \itemize{
\item{\strong{kernel.type}{ see \code{\link{kernel.fun}} for further details}}
}}
}
\value{
\code{model} returns a \code{model.class} object. This class contains two main methods:
\itemize{
\item{plot(mdfit,\eqn{\Theta},var, points=FALSE)}{ this metod generates the plot for a new
\eqn{\Theta}, \eqn{\sigma^2} and a new set of data. The option points allows to vizualize the points from
the Design Of Experiments (DOE) used for establishing the surrogate.}
\item{print()}{ this method presents the main information about the model.}
}
}
\description{
\code{model} is a function that generates a calibration model and the associated likelihood.
}
\details{
The different statistical models are: \itemize{\item{Model1:
\deqn{for i in [1,...,n]  Yexp_i=f(x_i,\Theta)+\epsilon(x_i)}}
\item{Model2:
\deqn{for i in [1,...,n]  Yexp_i=F(x_i,\Theta)+\epsilon(x_i)}}
\item{Model3:
\deqn{for i in [1,...,n]  Yexp_i=f(x_i,\Theta)+\delta(x_i)+\epsilon(x_i)}}
\item{Model4:
\deqn{for i in [1,...,n]  Yexp_i=F(x_i,\Theta)+\delta(x_i)+\epsilon(x_i)}}
}
where \eqn{for i in [1,\dots,n] \epsilon(x_i)~N(0,\sigma^2)}, \eqn{F(.,.)~PG(m_1(.,.),c_1{(.,.),(.,.)})}
 and \eqn{\delta(.)~PG(m_2(.),c_2(.,.))}.
There is four kind of models in calibration. They are properly defined in [1].
}
\examples{
\dontrun{
###### The code to calibrate
X <- cbind(seq(0,1,length.out=4),seq(0,1,length.out=4))
code <- function(X,theta)
{
  return((6*X[,1]*theta[2]-2)^2*theta[1]*sin(theta[3]*X[,2]-4))
}
Yexp <- code(X,c(1,1,11))+rnorm(4,0,0.1)

###### For the first model
### Generate the model
model1 <- model(code,X,Yexp,"model1")
### Plot the results with the first column of X
plot(model1,c(1,1,11),0.1,select.X=X[,1])
### Summury of the foo class generated
print(model1)

###### For the second model
### Generate the model with setup for the Gaussian Process
binf <- c(0.9,0.9,10.5)
bsup <- c(1.1,1.1,11.5)
opt.emul <- list(p=3,n.emul=10,type="matern5_2",binf=binf,bsup=bsup,DOE=NULL)
model2 <- model(code,X,Yexp,"model2",opt.emul)
### Plot the model
plot(model2,c(1,1,11),0.1,select.X=X[,1])

### Use your own design of experiments
DOE <- DiceDesign::lhsDesign(10,5)$design
DOE[,3:5] <- unscale(DOE[,3:5],binf,bsup)
opt.emul <- list(p=3,n.emul=10,type="matern5_2",binf=c(0.9,0.9,10.5),bsup=c(1.1,1.1,11.5),DOE=DOE)
model2 <- model(code,X,Yexp,"model2",opt.emul)
plot(model2, theta=c(1,1,11),var=0.1,points=FALSE,select.X=X[,1])

###### For the third model
model3 <- model(code,X,Yexp,"model3",opt.disc=list(kernel.type="matern5_2"))
plot(model3,theta=c(1,1,11),thetaD=c(0,0.01),var=0.01,select.X=X[,1])
print(model3)

}

}
\seealso{
\code{\link{prior}},\code{\link{calibrate}},\code{\link{prediction}}, \code{\link{kernel.fun}}
}
\author{
M. Carmassi
}
