% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_dim.R
\name{predict_dim}
\alias{predict_dim}
\title{Estimate Dimension of the Sufficient Reduction.}
\usage{
predict_dim(object, ..., method = "CV")
}
\arguments{
\item{object}{an object of class \code{"cve"}, usually, a result of a call to
\code{\link{cve}} or \code{\link{cve.call}}.}

\item{...}{ignored.}

\item{method}{This parameter specifies which method is used in dimension
 estimation. It provides three options: \code{'CV'} (default),
\code{'elbow'} and \code{'wilcoxon'}.}
}
\value{
A \code{list} with
\describe{
   \item{}{criterion for method and \code{k = min.dim, ..., max.dim}.}
   \item{k}{estimated dimension is the minimizer of the criterion.}
}
}
\description{
This function estimates the dimension, i.e. the rank of \eqn{B}. The default
method \code{'CV'} performs leave-one-out (LOO) cross-validation using
\code{mars} as follows for \code{k = min.dim, ..., max.dim} a
cross-validation via \code{mars} is
performed on the dataset \eqn{(Y_i, B_k' X_i)_{i = 1, ..., n}} where
\eqn{B_k} is the \eqn{p \times k}{p x k} dimensional CVE estimate. The
estimated SDR dimension is the \eqn{k} where the
cross-validation mean squared error is minimal. The method \code{'elbow'}
estimates the dimension via \eqn{k = argmin_k L_n(V_{p - k})} where
\eqn{V_{p - k}} is the space that is orthogonal to the column space of the 
CVE estimate of \eqn{B_k}. Method \code{'wilcoxon'}  finds the minimum using
the Wilcoxon test.
}
\examples{
# create B for simulation
B <- rep(1, 5) / sqrt(5)

set.seed(21)
# creat predictor data x ~ N(0, I_p)
x <- matrix(rnorm(500), 100)

# simulate response variable
#    y = f(B'x) + err
# with f(x1) = x1 and err ~ N(0, 0.25^2)
y <- x \%*\% B + 0.25 * rnorm(100)

# Calculate cve for unknown k between min.dim and max.dim.
cve.obj.simple <- cve(y ~ x)

predict_dim(cve.obj.simple)

}
