% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reductions.R
\docType{class}
\name{Canonicalization-class}
\alias{Canonicalization-class}
\alias{.Canonicalization}
\alias{perform,Canonicalization,Problem-method}
\alias{invert,Canonicalization,Solution,InverseData-method}
\alias{canonicalize_tree,Canonicalization-method}
\alias{canonicalize_expr,Canonicalization-method}
\title{The Canonicalization class.}
\usage{
\S4method{perform}{Canonicalization,Problem}(object, problem)

\S4method{invert}{Canonicalization,Solution,InverseData}(object, solution, inverse_data)

\S4method{canonicalize_tree}{Canonicalization}(object, expr)

\S4method{canonicalize_expr}{Canonicalization}(object, expr, args)
}
\arguments{
\item{object}{A \linkS4class{Canonicalization} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{solution}{A \linkS4class{Solution} to a problem that generated the inverse data.}

\item{inverse_data}{An \linkS4class{InverseData} object that contains the data encoding the original problem.}

\item{expr}{An \linkS4class{Expression} object.}

\item{args}{List of arguments to canonicalize the expression.}
}
\description{
This class represents a canonicalization reduction.
}
\section{Methods (by generic)}{
\itemize{
\item \code{perform}: Recursively canonicalize the objective and every constraint.

\item \code{invert}: Performs the reduction on a problem and returns an equivalent problem.

\item \code{canonicalize_tree}: Recursively canonicalize an Expression.

\item \code{canonicalize_expr}: Canonicalize an expression, w.r.t. canonicalized arguments.
}}

