% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.getDirSim.r
\name{stat.getDirSim}
\alias{stat.getDirSim}
\title{DirSim: The Jaccard distance with directionality incorporated.}
\usage{
stat.getDirSim(ptID, ptID2, kmx, data_mx)
}
\arguments{
\item{ptID}{- The identifier associated with patient 1's sample.}

\item{ptID2}{- The identifier associated with patient 2's sample.}

\item{kmx}{- The number of top perturbations to consider in distance
calculation.}

\item{data_mx}{- The matrix that gives the perturbation strength
(z-scores) for all variables (columns) for each
patient (rows).}
}
\value{
dirSim - a distance matrix, where row and columns are
patient identifiers.
}
\description{
DirSim: The Jaccard distance with directionality incorporated.
}
\examples{
# Get patient distances for the first 2 patients in the Miller 2015 dataset.
data("Miller2015")
data_mx = Miller2015[-c(1,grep("x - ", rownames(Miller2015))),
                        grep("IEM",colnames(Miller2015))]
data_mx = apply(data_mx[,c(1,2)], c(1,2), as.numeric)
# Look at the top 5 metabolites for each patient. 
kmx=5
# Build your results ("res") list object to store patient distances at
# different size k's.
res = list()
t = list(dir=matrix(NA, nrow=ncol(data_mx), ncol=ncol(data_mx)))
rownames(t$dir) = colnames(data_mx)
colnames(t$dir) = colnames(data_mx)
for (i in seq_len(kmx)) { res[[i]] = t }
for (pt in seq_len(ncol(data_mx))) {
    print(pt)
    ptID=colnames(data_mx)[pt]
    for (pt2 in pt:ncol(data_mx)) {
        ptID2=colnames(data_mx)[pt2]
        tmp=stat.getDirSim(ptID,ptID2,kmx,data_mx)
        for (k in seq_len(kmx)) {
            res[[k]]$dir[ptID, ptID2]=tmp[k]
            res[[k]]$dir[ptID2, ptID]=tmp[k]
        }
    }
}
}
