% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleNode.getNodeRanksN.r
\name{singleNode.getNodeRanksN}
\alias{singleNode.getNodeRanksN}
\title{Generate single-node node rankings ("fixed" walk)}
\usage{
singleNode.getNodeRanksN(n,G,p1,thresholdDiff,adj_mat,
                                    S=NULL,num.misses=NULL,verbose=FALSE,
                                    out_dir="",useLabels=FALSE,coords=NULL)
}
\arguments{
\item{n}{- The index (out of a vector of node names) of the node ranking
you want to calculate.}

\item{G}{- A list of probabilities with list names being the node names
of the network.}

\item{p1}{- The probability that is preferentially distributed between
network nodes by the probability diffusion algorithm based
solely on network connectivity. The remaining probability
(i.e., "p0") is uniformally distributed between network nodes,
regardless of connectivity.}

\item{thresholdDiff}{- When the probability diffusion algorithm exchanges 
this amount or less between nodes, the algorithm 
returns up the call stack.}

\item{adj_mat}{- The adjacency matrix that encodes the edge weights for the 
network, G.}

\item{S}{- A character vector of node names in the subset you want the 
network walker to find.}

\item{num.misses}{- The number of "misses" the network walker will tolerate
before switching to fixed length codes for remaining
nodes to be found.}

\item{verbose}{- If TRUE, print statements will execute as progress is made.
Default is FALSE.}

\item{out_dir}{- If specified, a image sequence will generate in the 
output directory specified.}

\item{useLabels}{- If TRUE, node names will display next to their respective
nodes in the network. If FALSE, node names will not
display. Only relevant if out_dir is specified.}

\item{coords}{- The x and y coordinates for each node in the network, to 
remain static between images.}
}
\value{
curr_ns - A character vector of node names in the order they
were drawn by the probability diffusion algorithm.
}
\description{
This function calculates the node rankings starting from a given perturbed 
variable in a subset of variables in the network.
}
\examples{
# Build an adjacency matrix for network G
adj_mat=rbind(c(0,1,2,0,0,0,0,0,0), #A's neighbors
                c(1,0,3,0,0,0,0,0,0), #B's neighbors
                c(2,3,0,0,1,0,0,0,0), #C's neighbors
                c(0,0,0,0,0,0,1,1,0), #D's neighbors
                c(0,0,1,0,0,1,0,0,0), #E's neighbors
                c(0,0,0,0,1,0,0,0,0), #F's neighbors
                c(0,0,0,1,0,0,0,1,0), #G's neighbors
                c(0,0,0,1,0,0,1,0,0), #H's neighbors
                c(0,0,0,0,0,0,0,0,0) #I's neighbors
                )
rownames(adj_mat)=c("A","B","C","D","E","F","G","H","I")
colnames(adj_mat)=c("A","B","C","D","E","F","G","H","I")
G=vector("numeric", length=ncol(adj_mat))
names(G)=colnames(adj_mat)
# Get node rankings for the first metabolite in network G. 
ranks=singleNode.getNodeRanksN(1,G,p1=0.9,thresholdDiff=0.01,adj_mat)
}
\keyword{diffusion}
\keyword{network}
\keyword{probability}
\keyword{walker}
