% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MultiEOF.R
\name{MultiEOF}
\alias{MultiEOF}
\title{EOF analysis of multiple variables starting from an array (reduced version)}
\usage{
MultiEOF(
  data,
  lon,
  lat,
  time,
  lon_dim = "lon",
  lat_dim = "lat",
  neof_max = 40,
  neof_composed = 5,
  minvar = 0.6,
  lon_lim = NULL,
  lat_lim = NULL
)
}
\arguments{
\item{data}{A multidimensional array with dimension \code{"var"},
containing the variables to be analysed. The other diemnsions follow the same structure as the
\code{"exp"} element of a 's2dv_cube' object.}

\item{lon}{Vector of longitudes.}

\item{lat}{Vector of latitudes.}

\item{time}{Vector or matrix of dates in POSIXct format.}

\item{lon_dim}{String with dimension name of longitudinal coordinate}

\item{lat_dim}{String with dimension name of latitudinal coordinate}

\item{neof_max}{Maximum number of single eofs considered in the first decomposition}

\item{neof_composed}{Number of composed eofs to return in output}

\item{minvar}{Minimum variance fraction to be explained in first decomposition}

\item{lon_lim}{Vector with longitudinal range limits for the calculation for all input variables}

\item{lat_lim}{Vector with latitudinal range limits for the calculation for all input variables}
}
\value{
A list with elements \code{$coeff} (an array of time-varying principal component coefficients),
        \code{$variance} (a matrix of explained variances),
        \code{eof_pattern} (a matrix of EOF patterns obtained by regression for each variable).
}
\description{
This function performs EOF analysis over multiple variables, accepting in input an array with a dimension \code{"var"} for each variable to analyse. Based on Singular Value Decomposition. For each field the EOFs are computed and the corresponding PCs are standardized (unit variance, zero mean); the minimum number of principal components needed to reach the user-defined variance is retained. The function weights the input data for the latitude cosine square root.
}
\author{
Jost von Hardenberg - ISAC-CNR, \email{j.vonhardenberg@isac.cnr.it}

Paolo Davini - ISAC-CNR, \email{p.davini@isac.cnr.it}
}
