% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.s2dv_cube.R
\name{as.s2dv_cube}
\alias{as.s2dv_cube}
\title{Conversion of 'startR_array' or 'list' objects to 's2dv_cube'}
\usage{
as.s2dv_cube(object)
}
\arguments{
\item{object}{an object of class 'startR_array' generated from function \code{Start} from startR package (version 0.1.3 from earth.bsc.es/gitlab/es/startR) or a list output from function \code{Load} from s2dverification package.}
}
\value{
The function returns a 's2dv_cube' object to be easily used with functions \code{CST} from CSTools package.
}
\description{
This function converts data loaded using startR package or s2dverification Load function into a 's2dv_cube' object.
}
\examples{
\dontrun{
library(startR)
repos <- '/esarchive/exp/ecmwf/system5_m1/monthly_mean/$var$_f6h/$var$_$sdate$.nc'
data <- Start(dat = repos,
             var = 'tas',
             sdate = c('20170101', '20180101'),
             ensemble = indices(1:20),
             time = 'all',
             latitude = 'all',
             longitude = indices(1:40),
             return_vars = list(latitude = 'dat', longitude = 'dat', time = 'sdate'),
             retrieve = TRUE)
data <- as.s2dv_cube(data)
class(data)
startDates <- c('20001101', '20011101', '20021101',
                '20031101', '20041101', '20051101')
data <- Load(var = 'tas', exp = 'system5c3s', 
            nmember = 15, sdates = startDates,
            leadtimemax = 3, latmin = 27, latmax = 48,
            lonmin = -12, lonmax = 40, output = 'lonlat')
data <- as.s2dv_cube(data)
class(data)
}
}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}

Nicolau Manubens, \email{nicolau.manubens@bsc.es}
}
\seealso{
\code{\link{s2dv_cube}}, \code{\link[s2dverification]{Load}}, \code{\link[startR]{Start}} and \code{\link{CST_Load}}
}

