% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csgo_api_profile.R
\name{csgo_api_profile}
\alias{csgo_api_profile}
\title{CS Go User Profile}
\usage{
csgo_api_profile(api_key, user_id, name = FALSE)
}
\arguments{
\item{api_key}{string with the key provided by the steam API.

PS: If you don`t have a API key yet run \code{vignette("auth", package = "CSGo")} and follow the presented steps.}

\item{user_id}{string with the steam user ID.

Steam ID is the NUMBER OR NAME at the end of your steam profile URL. ex: '76561198263364899'.

PS: The user should have a public status.}

\item{name}{logical: if the user_id input is a name change it for TRUE. ex: 'generalcapivara'.}
}
\value{
data frame with all the CS Go friends of the user ID.
}
\description{
This function will return the CS Go Profile of the user_id (input).
}
\examples{
\dontrun{
## It is necessary to fill the "api_key" parameter to run the example

df_profile <- csgo_api_profile(api_key = 'XXX', user_id = '76561198263364899')

df_profile <- csgo_api_profile(api_key = 'XXX', user_id = 'generalcapivara', name = TRUE)
}
}
