% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_cre_dataset.R
\name{generate_cre_dataset}
\alias{generate_cre_dataset}
\title{Generate CRE Synthetic Data}
\usage{
generate_cre_dataset(
  n = 1000,
  rho = 0,
  n_rules = 2,
  p = 10,
  effect_size = 2,
  binary = FALSE
)
}
\arguments{
\item{n}{An integer number that represents the number of observations. Non-integer
values will be converted into an integer number.}

\item{rho}{A positive double number (0,1) that represents the correlation
within the covariates (default: 0).}

\item{n_rules}{The number of causal rules, either 2 (default) or 4.}

\item{p}{The number of covariates (default: 10).}

\item{effect_size}{The effect size magnitude (default: 0.5).
TODO: what is the range of effect size magnitude?}

\item{binary}{Whether to use binary or continuous outcomes,
either TRUE (default) or FALSE.}
}
\value{
A list of synthetic data containing an outcome vector (y), a treatment
vector (z), and a matrix of p covariates (X).
}
\description{
Generates synthetic data with continues or binary outcome
}
\examples{
set.seed(123)
dataset <- generate_cre_dataset(n = 1000, rho = 0, n_rules = 2, p = 10,
                                effect_size = 2, binary = FALSE)

}
