% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMMA_boot_sample.R
\name{COMMA_boot_sample}
\alias{COMMA_boot_sample}
\title{Generate Bootstrap Samples for Estimating Standard Errors}
\usage{
COMMA_boot_sample(
  parameter_estimates,
  sigma_estimate = 1,
  outcome_distribution,
  interaction_indicator,
  x_matrix,
  z_matrix,
  c_matrix
)
}
\arguments{
\item{parameter_estimates}{A column matrix of \eqn{\beta}, \eqn{\gamma},
and \eqn{\theta} parameter values obtained from a COMMA analysis function.
Parameter estimates should be supplied in the following order: 1) \eqn{\beta}
(intercept, slope), 2) \eqn{\gamma} (intercept and slope from the M = 1
mechanism, intercept and slope from the M = 2 mechanism), and 3) \eqn{\theta}
(intercept, slope, coefficient for \code{x}, slope coefficient for \code{m},
slope coefficient for \code{c}, and, optionally, slope coefficient for
\code{xm} if using).}

\item{sigma_estimate}{A numeric value specifying the estimated
standard deviation. This value is only required if \code{outcome_distribution}
is \code{"Normal"}. Default is 1. For non-Normal outcome distributions, the
value should be \code{NULL}.}

\item{outcome_distribution}{A character string specifying the distribution of
the outcome variable. Options are \code{"Bernoulli"}, \code{"Normal"}, or
\code{"Poisson"}.}

\item{interaction_indicator}{A logical value indicating if an interaction between
\code{x} and \code{m} should be used to generate the outcome variable, \code{y}.}

\item{x_matrix}{A numeric matrix of predictors in the true mediator and outcome mechanisms.
\code{x_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{z_matrix}{A numeric matrix of covariates in the observation mechanism.
\code{z_matrix} should not contain an intercept and no values should be \code{NA}.}

\item{c_matrix}{A numeric matrix of covariates in the true mediator and outcome mechanisms.
\code{c_matrix} should not contain an intercept and no values should be \code{NA}.}
}
\value{
\code{COMMA_boot_sample} returns a list with the bootstrap sample data:
\item{obs_mediator}{A vector of observed mediator values.}
\item{true_mediator}{A vector of true mediator values.}
\item{outcome}{A vector of outcome values.}
\item{x_matrix}{A matrix of predictor values in the true mediator
mechanism. Identical to that supplied by the user.}
\item{z_matrix}{A matrix of predictor values in the observed mediator
mechanism. Identical to that supplied by the user.}
\item{c_matrix}{A matrix of covariates. Identical to that supplied by the user.}
}
\description{
Generate Bootstrap Samples for Estimating Standard Errors
}
