% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_panel}
\alias{impute_panel}
\title{Impute panel data}
\usage{
impute_panel(
  iData,
  time_col = NULL,
  unit_col = NULL,
  cols = NULL,
  max_time = NULL
)
}
\arguments{
\item{iData}{A data frame of indicator data, containing a time index column \code{time_col}, a unit code column \code{unit_col},
and other numerical columns to be imputed.}

\item{time_col}{The name of a column found in \code{iData} to be used as the time index column. Must point to a numeric column.}

\item{unit_col}{The name of a column found in \code{iData} to be used as the unit code/ID column. Must point to a character column.}

\item{cols}{Optionally, a character vector of names of columns to impute. If \code{NULL} (default), all columns apart from \code{time_col} and
\code{unit_col} will be imputed where possible.}

\item{max_time}{The maximum number of time points to look backwards to impute from. E.g. if \code{max_time = 1}, if an
\code{NA} is found at time \eqn{t}, it will only look for a replacement value at \eqn{t-1} but not in any time points before that.
By default, searches all time points available.}
}
\value{
A list containing:
\itemize{
\item \code{.$iData_imp}: An \code{iData} format data frame with missing data imputed using previous time points (where possible).
\item \code{.$DataT}: A data frame in the same format as \code{iData}, where each entry shows which time point each data point
came from.
}
}
\description{
Given a data frame of panel data, with a time-index column \code{time_col} and a unit ID column \code{unit_col}, imputes other
columns using the entry from the latest available time point.
}
\details{
This presumes that there are multiple observations for each unit code, i.e. one per time point. It then searches for any missing values in the target year, and replaces them with the equivalent points
from previous time points. It will replace using the most recently available point.
}
\examples{
# Copy example panel data
iData_p <- ASEM_iData_p

# we introduce two NAs: one for NZ in 2022 in LPI indicator
iData_p$LPI[iData_p$uCode == "NZ" & iData_p$Time == 2022] <-  NA
# one for AT, also in 2022, but for Flights indicator
iData_p$Flights[iData_p$uCode == "AT" & iData_p$Time == 2022] <- NA

# impute: target only the two columns where NAs introduced
l_imp <- impute_panel(iData_p, cols = c("LPI", "Flights"))
# get imputed df
iData_imp <- l_imp$iData_imp

# check the output is what we expect: both NAs introduced should now have 2021 values
iData_imp$LPI[iData_imp$uCode == "NZ" & iData_imp$Time == 2022] ==
  ASEM_iData_p$LPI[ASEM_iData_p$uCode == "NZ" & ASEM_iData_p$Time == 2021]

iData_imp$Flights[iData_imp$uCode == "AT" & iData_imp$Time == 2022] ==
  ASEM_iData_p$Flights[ASEM_iData_p$uCode == "AT" & ASEM_iData_p$Time == 2021]

}
