% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{get_corr_flags}
\alias{get_corr_flags}
\title{Find highly-correlated indicators within groups}
\usage{
get_corr_flags(
  coin,
  dset,
  cor_thresh = 0.9,
  thresh_type = "high",
  cortype = "pearson",
  grouplev = NULL,
  roundto = 3
)
}
\arguments{
\item{coin}{A coin class object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{cor_thresh}{A threshold to flag high correlation. Default 0.9.}

\item{thresh_type}{Either \code{"high"}, which will only flag correlations \emph{above} \code{cor_thresh}, or \code{"low"},
which will only flag correlations \emph{below} \code{cor_thresh}.}

\item{cortype}{The type of correlation, either \code{"pearson"} (default), \code{"spearman"} or \code{"kendall"}. See \link[stats:cor]{stats::cor}.}

\item{grouplev}{The level to group indicators in. E.g. if \code{grouplev = 2} it will look for high correlations between indicators that
belong to the same group in Level 2.}

\item{roundto}{Number of decimal places to round correlations to. Default 3. Set \code{NULL} to disable rounding.}
}
\value{
A data frame with one entry for every indicator pair that is highly correlated within the same group, at the specified level.
Pairs are only reported once, i.e. only uses the upper triangle of the correlation matrix.
}
\description{
This returns a data frame of any highly correlated indicators within the same aggregation group. The level of the aggregation
grouping can be controlled by the \code{grouplev} argument.
}
\details{
This function is motivated by the idea that having very highly-correlated indicators within the same group may
amount to double counting, or possibly redundancy in the framework.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "Normalise", quietly = TRUE)

# get correlations between indicator over 0.75 within level 2 groups
get_corr_flags(coin, dset = "Normalised", cor_thresh = 0.75,
               thresh_type = "high", grouplev = 2)

}
