% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_poles.R
\name{financial_cof_poles}
\alias{financial_cof_poles}
\title{Financial cost of Failure for Poles}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_poles(
  pole_asset_category,
  type_financial_factor_criteria,
  access_factor_criteria
)
}
\arguments{
\item{pole_asset_category}{String The type of pole asset category
Options: \code{pole_asset_category = c("LV Poles", "6.6/11kV Poles",
"20kV Poles", "33kV Pole", "66kV Pole")}.}

\item{type_financial_factor_criteria}{String. Type Financial factor criteria for Pole
Options: \code{type_financial_factor_criteria = c("Pole (supporting conductor only)",
"Pole (supporting plant or equipment)", "Small footprint steel masts")}.}

\item{access_factor_criteria}{String. Asses Financial factor criteria for Pole
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B")}.}
}
\value{
Numeric. Financial consequences of failure for Poles
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_poles(pole_asset_category = "33kV Pole",
type_financial_factor_criteria = "Small footprint steel masts",
access_factor_criteria = "Type A")
}
