% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubble_plot.R
\name{bubble_plot}
\alias{bubble_plot}
\title{Bubble plot of CMap output table}
\usage{
bubble_plot(path, plot, enrichment, abs.enrich.cutoff=NULL, n.rep.cutoff=NULL ,
        jittering=FALSE, return.gg.table= FALSE, output_path = NULL)
}
\arguments{
\item{path}{path of the excel file}

\item{plot}{what data to plot: molecules only (plot="molecules") or molecules by cell lines batch (plot="cell.lines")}

\item{enrichment}{whether to plot positive or negative enrichment}

\item{abs.enrich.cutoff}{minimum value of enrichment to include a batch}

\item{n.rep.cutoff}{minimum number of replicates to include a batch (default=NULL)}

\item{jittering}{whether apply jittering to the values to avoid points overlap}

\item{return.gg.table}{table prepared for ggplot, allows the user to customize the graphical representation}

\item{output_path}{path for the experiment output folder, returns data table and figure (default=NULL)}
}
\value{
ggplot object - bubble plot
}
\description{
This function allows the user to represent the Connectivity Map (CMap) result table (broadinstitute)
under the form of a bubble plot representing statistics and cell lines:
- each drug is represented along the y axis according to its enrichment value
- each drug is represented along the x axis according to the cell line tested and
within the cell line according to batch specificity (0-50% <- vertical line -> 50-100%)
}
\examples{
file.path <- system.file("extdata", "example.xls", package = "CMapViz")
#display results by cell lines, with negative enrichment (absolute cutoff: 0.5), and at least n=5.
#molecule position with respect of dotted line is the specificity of the molecule itself:
#left side of dotted line if specificity < 50 or right side of dotted line if specificity > 50 )
bubble_plot(file.path,
    plot = "cell.lines", enrichment = "negative", abs.enrich.cutoff = 0.5,
    n.rep.cutoff = 5, output_path = NULL
)
}
