% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLONETv2_compute_admixture.R
\name{compute_dna_admixture}
\alias{compute_dna_admixture}
\title{Function to compute DNA admixture of a tumor sample from the associatd beta
table and ploidy table}
\usage{
compute_dna_admixture(beta_table, ploidy_table, min_required_snps = 10,
  min_coverage = 20, error_tb = error_table, n_digits = 3,
  n_cores = 1, debug = F)
}
\arguments{
\item{beta_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_beta_table}}}

\item{ploidy_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_ploidy]{compute_ploidy}}}

\item{min_required_snps}{minimum number of informative snps in  a segment
valid for computing ploidy (default=10)}

\item{min_coverage}{minimum coverage of a segment valid for computing ploidy
(default=20)}

\item{error_tb}{data.frame that reports for each combination of coverage and
number informative SNPs the expected estimation error around beta. The
data.frame error_tb must contains 3 columns: \describe{
\item{mean.cov}{mean coverage} \item{n.info.snps}{number of informative
SNPs} \item{adm.estimation.error}{estimated error on computed beta on a
segment with coverage mean.cov and n.info.snps informative SNPs} } Package
CLONETv2 have built in error_tb named error_table (default=error_table)}

\item{n_digits}{number of digits in the output table (default=3)}

\item{n_cores}{number of available cores for computation (default=1)}

\item{debug}{return extra columns for debugging (default=F)}
}
\value{
A data.frame with two columns: sample that corresponds to column
sample of the input beta_table, and amd that represent the fraction of
estimated DNA admixture
}
\description{
This function takes a beta table and the associated ploidy table and computes
DNA admixture.
}
\examples{

## Compute admixture table with default parameters
adm_table_toy <- compute_dna_admixture(beta_table = bt_toy, ploidy_table = pl_table_toy)

}
\author{
Davide Prandi
}
