% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_survival_from_census.R
\name{summarize_survival_from_census}
\alias{summarize_survival_from_census}
\title{Summarize annual sex-and-age-specific survival rates from the census information}
\usage{
summarize_survival_from_census(
  census,
  fem_surv_probs = NULL,
  male_surv_probs = NULL,
  nbins = 10
)
}
\arguments{
\item{census}{a tibble of census counts with columns \code{year} and
\code{age}, and then the counts of the different sexes in columns
named \code{male}, and \code{female}.}

\item{fem_surv_probs}{a vector of the parameters used for the simulation.  If present
these are put on the histogram plots. If you provide one of these, you have to provide both.}

\item{male_surv_probs}{a vector of the parameters used for the simulation.  If present
these are put on the histogram plots.}

\item{nbins}{number of bins for the histograms}
}
\value{
A list with components:
\itemize{
\item \code{survival_tibble}:  A tibble with the following columns:
\itemize{
\item \code{year}: The year
\item \code{pop}: The population whose census is being counted
\item \code{age}: The age of individuals
\item \code{sex}: The sex of individuals
\item \code{n}: The number of individuals alive and present of sex \code{sex} and age \code{age} in year
\code{year} in pop \code{pop}.
\item \code{cohort}: The birth year of these individuals
\item \code{surv_fract}: The fraction of the n individuals that survive to have age \code{age + 1} in
year \code{year + 1}.
}
\item \code{plot_histos_by_age_and_sex}: A ggplot object of histograms of observed survival fractions
facet-wrapped by age and sex.  Blue vertical lines are the observed means and dashed vertical
red lines are the expected values given the simulation parameters.
}
}
\description{
The prekill census in year t+1 is the post-kill census in year t, so
we can use the prekill census to record the realized fraction of individuals
of each age and sex that survived the death episode in each year.  In the
output survival in year t is the fraction of j-year olds in year t that
survive to be j+1 year-olds in year t+1.
}
\details{
This function does not track migrants.  Another one is eventually
in order that accounts for migrants out of the population.  Also,
the plots here might not play well with multiple populations.
}
\examples{
result <- summarize_survival_from_census(
  species_1_slurped_results$census_prekill,
  species_1_life_history$`fem-surv-probs`,
  species_1_life_history$`male-surv-probs`
)

# print the results if you want
result$survival_tibble
result$plot_histos_by_age_and_sex

}
