% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{valplot}
\alias{valplot}
\title{Plot validation prediction errors}
\usage{
valplot(predmean, predvar, Yval, d = NULL)
}
\arguments{
\item{predmean}{Predicted mean}

\item{predvar}{Predicted variance}

\item{Yval}{Y validation data}

\item{d}{If output is multivariate, which column to use. Will do all if
left as NULL.}
}
\value{
None, makes a plot
}
\description{
Plot validation prediction errors
}
\examples{
x <- matrix(runif(100*3), ncol=3)
f1 <- function(x){x[1]+x[2]^2}
y <- apply(x, 1, f1)
# Create a linear model on the data
mod <- lm(y ~ ., data.frame(x))
# Predict at validation data
Xval <- matrix(runif(3*100), ncol=3)
mod.pred <- predict.lm(mod, data.frame(Xval), se.fit=TRUE)
# Compare to true results
Yval <- apply(Xval, 1, f1)
valplot(mod.pred$fit, mod.pred$se.fit^2, Yval=Yval)
}
