% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{as_timestamp}
\alias{as_timestamp}
\title{Create a vector that represents CF timestamps}
\usage{
as_timestamp(t, format = NULL, asPOSIX = FALSE)
}
\arguments{
\item{t}{The \code{CFTime} instance that contains the offsets to use.}

\item{format}{character. A character string with either of the values "date"
or "timestamp". If the argument is not specified, the format used is
"timestamp" if there is time information, "date" otherwise.}

\item{asPOSIX}{logical. If \code{TRUE}, for "standard", "gregorian" and
"proleptic_gregorian" calendars the output is a vector of \code{POSIXct} - for
other calendars an error will be thrown. Default value is \code{FALSE}.}
}
\value{
A character vector where each element represents a moment in time
according to the \code{format} specifier.
}
\description{
This function generates a vector of character strings or \code{POSIXct}s that
represent the date and time in a selectable combination for each offset.
}
\details{
The character strings use the format \verb{YYYY-MM-DDThh:mm:ss±hhmm}, depending on
the \code{format} specifier. The date in the string is not necessarily compatible
with \code{POSIXt} - in the \verb{360_day} calendar \code{2017-02-30} is valid and
\code{2017-03-31} is not.

For the "proleptic_gregorian" calendar the output can also be generated as a
vector of \code{POSIXct} values by specifying \code{asPOSIX = TRUE}. The same is
possible for the "standard" and "gregorian" calendars but only if all
timestamps fall on or after 1582-10-15.
}
\examples{
t <- CFtime("hours since 2020-01-01", "standard", seq(0, 24, by = 0.25))
as_timestamp(t, "timestamp")

t2 <- CFtime("days since 2002-01-21", "standard", 0:20)
tail(as_timestamp(t2, asPOSIX = TRUE))

tail(as_timestamp(t2))

tail(as_timestamp(t2 + 1.5))
}
\seealso{
The \link{CFTime} \code{format()} method gives greater flexibility through
the use of \code{strptime}-like format specifiers.
}
