% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFO2d.selectmtd.R
\name{CFO2d.selectmtd}
\alias{CFO2d.selectmtd}
\title{Select the maximum tolerated dose (MTD) for the real drug combination trial}
\usage{
CFO2d.selectmtd(target, npts, ntox, 
       prior.para = list(alp.prior = target, bet.prior = 1 - target), 
       cutoff.eli = 0.95, early.stop = 0.95, verbose = TRUE)
}
\arguments{
\item{target}{the target DLT rate.}

\item{npts}{a matrix containing the number of patients treated at each dose level.}

\item{ntox}{a matrix containing the number of patients who experienced DLT at each dose level.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{verbose}{set \code{verbose = TRUE} to return more details of the results.}
}
\value{
\code{CFO2d.selectmtd()} returns
\itemize{
\item target: the target DLT rate.
\item MTD: the selected MTD. \code{MTD = (99, 99)} indicates that all tested doses are overly toxic.
\item p_est: the isotonic estimate of the DLT probablity at each dose and associated \eqn{95\%} credible interval.
\code{p_est = NA} if all tested doses are overly toxic.
\item p_est_CI: the credible interval for the isotonic estimate.
\code{p_est_CI = NA} if all tested doses are overly toxic.
}
}
\description{
Select the maximum tolerated dose (MTD) when the real drug combination trial is completed
}
\details{
\code{CFO2d.selectmtd()} selects the MTD based on isotonic estimates of toxicity
probabilities. \code{CFO2d.selectmtd()} selects as the MTD dose \eqn{j^*}, for which the
isotonic estimate of the DLT rate is closest to the target. If there
are ties, we select from the ties the highest dose level when the estimate
of the DLT rate is smaller than the target, or the lowest dose level
when the estimate of the DLT rate is greater than the target. The
isotonic estimates are obtained by the pooled-adjacent-violators algorithm
(PAVA).
}
\note{
The MTD selection and dose escalation/deescalation rule are two independent
components of the trial design. Isotonic regression is employed to select the MTD after the completion of the trial.
When appropriate, another dose selection procedure (e.g., based on a fitted logistic model) can be used to select
the MTD after the completion of the trial using the 2dCFO design.
}
\examples{
ntox <- matrix(c(0, 0, 2, 0, 0,
                0, 2, 7, 0, 0,
                0, 2, 0, 0, 0), 
              nrow = 3, ncol = 5, byrow = TRUE)

npts <- matrix(c(3,  0, 12, 0, 0,
                3, 12, 24, 0, 0,
                3,  3,  0, 0, 0), 
              nrow = 3, ncol = 5, byrow = TRUE)
selmtd <- CFO2d.selectmtd(target=0.3, npts=npts, ntox=ntox)
summary(selmtd)
plot(selmtd)

}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Wang W, Jin H, Zhang Y, Yin G (2023). Two-dimensional calibration-free odds (2dCFO)
design for phase I drug-combination trials. \emph{Frontiers in Oncology}, 13, 1294258. \cr
Bril G, Dykstra R, Pillers C, Robertson T (1984). Algorithm AS 206: Isotonic regression in two independent variables.
\emph{Journal of the Royal Statistical Society. Series C (Applied Statistics)}, 33(3), 352–357.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
