% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKriging.R
\name{modelKrigingDistanceCalculation}
\alias{modelKrigingDistanceCalculation}
\title{Kriging: Distance Matrix Calculation}
\usage{
modelKrigingDistanceCalculation(x, distanceFunction, parameters = NA,
  distances, scaling, combineDistances, indefiniteMethod, indefiniteType,
  indefiniteRepair, lower)
}
\arguments{
\item{x}{list of samples in input space}

\item{distanceFunction}{a suitable distance function of type f(x1,x2), returning a scalar distance value, preferably between 0 and 1.
 Maximum distances larger 1 are no problem, but may yield scaling bias when different measures are compared.
    Should be non-negative and symmetric.  It can also be a list of several distance functions. In this case, Maximum Likelihood Estimation (MLE) is used 
to determine the most suited distance measure.
The distance function may have additional parameters.}

\item{parameters}{parameters passed to the distance function as a vector.}

\item{distances}{precomputed distances, set to NA if not available.}

\item{scaling}{boolean, whether to scale the distance matrix.}

\item{combineDistances}{boolean, whether to combine the distances of different functions.}

\item{indefiniteMethod}{method for handling non-conditionally-definite matrices.}

\item{indefiniteType}{type of handling for non-conditionally-definite matrices.}

\item{indefiniteRepair}{whether to further repair other conditions (beside definiteness).}

\item{lower}{lower boundary for distance function parameters.}
}
\value{
a list with elements \code{D} (distance matrix), \code{maxD} (maximal distance for scaling purpose).
}
\description{
Calculate and scale the distance matrix used in a Kriging model.
Include definiteness correction.
Not to be called directly.
}
\seealso{
\code{\link{modelKriging}}
}
\keyword{internal}
