% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoE.R
\name{designMaxMinDist}
\alias{designMaxMinDist}
\title{Max-Min-Distance Design}
\usage{
designMaxMinDist(x = NULL, cf, size, control = list())
}
\arguments{
\item{x}{Optional list of user specified solutions to be added to the design/population, defaults to NULL}

\item{cf}{Creation function, creates random new individuals}

\item{size}{size of the design}

\item{control}{list of controls. \code{control$distanceFunction} requires a distance function to compare two candidates created by cf. 
\code{control$budget} is the number of candidates for the random sampling, defaults to 100.}
}
\value{
Returns list with experimental design without duplicates
}
\description{
Build a design of experiments in a sequential manner: First candidate solution is created at random.
Afterwards, candidates are added sequentially, maximizing the minimum distances to the existing candidates.
Each max-min problem is resolved by random sampling.
The aim is to get a rather diverse design.
}
\examples{
# Create a design of 10 permutations, each with n=5 elements, 
# and with 50 candidates for each sample.
# Note, that in this specific case the number of candidates 
# should be no larger than factorial(n).
# The default (hamming distance) is used.
design <- designMaxMinDist(NULL,function()sample(5),10,
		control=list(budget=50))
# Create a design of 20 real valued 2d vectors, 
# with 100 candidates for each sample
# using euclidean distance.
design <- designMaxMinDist(NULL,function()runif(2),20,
	control=list(budget=100,
	distanceFunction=function(x,y)sqrt(sum((x-y)^2))))
# plot the resulting design
plot(matrix(unlist(design),,2,byrow=TRUE))
}
\seealso{
\code{\link{optimMaxMinDist}}, \code{\link{designRandom}}
}
\keyword{internal}
