% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceCalculation.R
\name{distanceMatrixWrapper}
\alias{distanceMatrixWrapper}
\title{Distance Matrix Wrapper}
\usage{
distanceMatrixWrapper(x, distanceFunction)
}
\arguments{
\item{x}{list of candidate solutions whose distance is evaluated}

\item{distanceFunction}{Distance function of type f(x,y)=r, where r is a scalar and x and y are candidate solutions whose distance is evaluated.}
}
\value{
matrix of distances between all solutions in list x
}
\description{
Wrapper to calculate the distance matrix, with one or multiple distance functions.
}
\examples{
x <- list(5:1,c(2,4,5,1,3),c(5,4,3,1,2))
dm1 <- distanceMatrix(x,distancePermutationHamming)
dm2 <- distanceMatrix(x,distancePermutationInsert)
dmBoth <- distanceMatrixWrapper(x,list(distancePermutationHamming,distancePermutationInsert))

}
\keyword{internal}

