% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_skll_assignments_ods.R
\name{read_skill_assignment_ods}
\alias{read_skill_assignment_ods}
\title{Read an assignment of taught and required skills for a set of learning objects from an ODS-file.}
\usage{
read_skill_assignment_ods(
  filename,
  taughtname = "Taught",
  requiredname = "Required",
  warnonly = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filename}{Name of the ODS-file}

\item{taughtname}{Name of the sheet with required assignment (default = "Taught")}

\item{requiredname}{Name of the sheet with required assignment (default = "Required")}

\item{warnonly}{Are non-compliant SAs allowed? (default = FALSE)}

\item{verbose}{Verbosity of compliance test (default = TRUE)}
}
\value{
List of two binary matrices, "taught" and "required".
}
\description{
\code{read_skill_assignment_ods} expects an ODS-file with two sheets assigning taught and
required, respectively, skills to learning objects with two columns each. The first
column contains the IDs of learning objects and the second row the IDs of single skills
required or taught, respectively, by this learning object.
It returns a list of two binary matrices, "taught" and "required". Each matrix has one
row per learning object and one column per skill. The cells contain a "1" if the skill
is taught or required, respectively, by the learning object and a "0" otherwise,
}
\seealso{
Other functions reading skill assignments: 
\code{\link{read_skill_assignment_csv}()},
\code{\link{read_skill_assignment_xlsx}()}
}
\concept{functions reading skill assignments}
