% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbConnectDetails.R
\name{dbConnectDetails}
\alias{dbConnectDetails}
\title{Save database connection information in an object}
\usage{
dbConnectDetails(drv, ...)
}
\arguments{
\item{drv}{A DBI driver (e.g. \code{RPostgres::Postgres()})}

\item{...}{DBI Driver parameters needed to create a connection using DBI::dbConnect()}
}
\value{
A dbConnectArgs object that can be passed to dbConnect
}
\description{
\code{dbConnectDetails} returns an object that can be used to connect to a database
with dbConnect at some future point in execution. Functions that need to create
a new connection to a database with \code{dbConnect} can accept a \code{dbConnectDetails} object
as an argument and use it to create a new connection.
}
\examples{
\dontrun{
library(DBI)
connectionDetails <- dbConnectDetails(RPostgres::Postgres(),
                                      dbname = "cdm",
                                      host = "localhost",
                                      user = "postgres",
                                      password = Sys.getenv("password"))

 selfContainedQuery <- function(dbConnectDetails) {
   con <- dbConnect(connectionDetails)
   on.exit(dbDisonnect(con))
   dbGetQuery(con, "select count(*) as n from synthea1k.person")
 }

selfContainedQuery(connectionDetails)
}

}
