% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_areas.r
\name{assign_areas}
\alias{assign_areas}
\title{Assign point locations to polygons}
\usage{
assign_areas(
  Input,
  Polys,
  AreaNameFormat = "GAR_Long_Label",
  Buffer = 0,
  NamesIn = NULL,
  NamesOut = NULL
)
}
\arguments{
\item{Input}{dataframe containing - at the minimum - Latitudes and Longitudes to be assigned to polygons.

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:
Latitude, Longitude, Variable 1, Variable 2, ... Variable x.}.}

\item{Polys}{character vector of polygon names (e.g., \code{Polys=c('ASDs','RBs')}).

\strong{Must be matching the names of the pre-loaded spatial objects (loaded via e.g., \code{ASDs=load_ASDs()})}}

\item{AreaNameFormat}{dependent on the polygons loaded. For the Secretariat's spatial objects loaded via 'load_' functions,
we have the following:

\code{'GAR_Name'} e.g., \code{'Subarea 88.2'}

\code{'GAR_Short_Label'} e.g., \code{'882'}

\code{'GAR_Long_Label'} (default) e.g., \code{'88.2'}

Several values may be entered if several \code{Polys} are used, e.g.:

\code{c('GAR_Short_Label','GAR_Name')}, in which case \code{AreaNameFormat} must be given in the same order as \code{Polys}.}

\item{Buffer}{numeric, distance in nautical miles to be added around the \code{Polys} of interest.
Can be specified for each of the \code{Polys} (e.g., \code{Buffer=c(2,5)}). Useful to determine whether locations are within
\code{Buffer} nautical miles of a polygon.}

\item{NamesIn}{character vector of length 2 specifying the column names of Latitude and Longitude fields in
the \code{Input}. \strong{Latitudes name must be given first, e.g.:

\code{NamesIn=c('MyLatitudes','MyLongitudes')}}.}

\item{NamesOut}{character, names of the resulting column names in the output dataframe,
with order matching that of \code{Polys} (e.g., \code{NamesOut=c('Recapture_ASD','Recapture_RB')}).
If not provided will be set as equal to \code{Polys}.}
}
\value{
dataframe with the same structure as the \code{Input}, with additional columns corresponding
to the \code{Polys} used and named after \code{NamesOut}.
}
\description{
Given a set of polygons and a set of point locations (given in decimal degrees),
finds in which polygon those locations fall.
Finds, for example, in which Subarea the given fishing locations occurred.
}
\examples{
\donttest{


#Generate a dataframe
MyData=data.frame(Lat=runif(100,min=-65,max=-50),
                  Lon=runif(100,min=20,max=40))

#Assign ASDs and SSRUs to these locations (first load ASDs and SSRUs)
ASDs=load_ASDs()
SSRUs=load_SSRUs()

MyData=assign_areas(Input=MyData,Polys=c('ASDs','SSRUs'),NamesOut=c('MyASDs','MySSRUs'))

#View(MyData)
table(MyData$MyASDs) #count of locations per ASD
table(MyData$MySSRUs) #count of locations per SSRU

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
