% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBDA_Consolidation.pipeline.R
\name{CBDA_Consolidation.pipeline}
\alias{CBDA_Consolidation.pipeline}
\title{CBDA Consolidation function for Compressive Big Data Analytics - LONI pipeline}
\usage{
CBDA_Consolidation.pipeline(top, max_covs, M, misValperc, range_k, range_n,
  label, workspace_directory = tempdir())
}
\arguments{
\item{top}{Top predictions to select out of the M}

\item{max_covs}{Top features to display and include in the Validation Step where nested models are tested}

\item{M}{Number of the BigData subsets on which perform Knockoff Filtering and SuperLearner feature mining}

\item{misValperc}{Percentage of missing values to introduce in BigData (used just for testing, to mimic real cases).}

\item{range_k}{Features Sampling Range - FSR}

\item{range_n}{Cases Sampling Range - CSR}

\item{label}{This is the label appended to RData workspaces generated within the CBDA calls}

\item{workspace_directory}{Directory where the results and workspaces are saved}
}
\value{
value
}
\description{
This CBDA function consolidates all the M workspaces generated in the
 Learning/Training step into a single workspace. It also ranks all the predictive models and selects
 the **top** ones to be sifted for top predictive features
 to be passed to the next step (i.e., **the Validation Step**).
}
