% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoBin_Binary.R
\name{autoBin.binary}
\alias{autoBin.binary}
\title{Auto Binning for Quantitative Variables - Binary}
\usage{
autoBin.binary(data, index)
}
\arguments{
\item{data}{data frame (features as columns and observations as rows). An outcome variable is required. The outcome variable (Y) MUST be the last column.}

\item{index}{index or a vector of indices of the quantitative variables that need to be automatically categorized.}
}
\value{
`autoBin.binary()` returns the entire data frame after automatic binary categorization for the selected quantitative variable(s).
}
\description{
Automatically suggest an optimal cutting point for categorizing a quantitative variable before using the \pkg{CASMI}-based functions. This function does binary cutting, that is, to convert the quantitative variable into a categorical variable with two levels/categories.
}
\examples{
## Use the "iris" dataset embedded in R
data("iris")
newData <- autoBin.binary(iris, c(1,2,3,4))
newData

}
