#' plot.caiser.powercurve
#'
#' S3 method for plotting _caiser.powercurve_ objects (the output of
#' [calc_power_curve()]).
#'
#' @param x list object of class _caiser.powercurve_
#'                     (generated by [calc_power_curve()])
#' @param ... other parameters to be passed down to specific plotting
#'            functions (currently unused)
#'
#' @examples
#' my.cpc <- calc_power_curve(ninstances = 10)
#' plot(my.cpc)
#'
#' @export
#'

# TESTED
plot.CAISErPowercurve <- function(x,...)
{

  # ========== Error catching ========== #
  assertthat::assert_that(
    "CAISErPowercurve" %in% class(x),
    length(x$d) == length(x$power))
  # ==================================== #

  myvals <- summary(x)
  d <- x$d
  power <- x$power
  graphics::plot(d, power, type = "b", pch = 20, cex = 0.8,
                 main = "Power curve", las = 1)
  for (i in 1:nrow(myvals)){
    x <- myvals$d[i]
    y <- myvals$power[i]
    graphics::points(x = c(x, x), y = c(0, y), type = "l", lty = 3, lwd = 1.2)
    graphics::points(x = c(0, x), y = c(y, y), type = "l", lty = 3, lwd = 1.2)
  }

  invisible(TRUE)
}
