/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.rosuda.JGR.JGR;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;

public class RUtils {
    public static Rengine R_ENGINE = JGR.R;

    public static String[] ls() {
        if (R_ENGINE == null) {
            return null;
        }
        REXP exp = R_ENGINE.eval("ls()");
        if (exp != null) {
            return exp.asStringArray();
        }
        return null;
    }

    public static Object[] ls(String rClass) {
        if (R_ENGINE == null) {
            return null;
        }
        ArrayList<String> vars = new ArrayList<String>();
        for (String var : RUtils.ls()) {
            String varClass;
            REXP exp = R_ENGINE.eval("attr(" + var + ", 'class')");
            if (exp == null || (varClass = exp.asString()) == null || varClass.compareTo(rClass) != 0) continue;
            vars.add(var);
        }
        return vars.toArray();
    }

    public static Object[] getDatasetList() {
        return RUtils.ls("data.frame");
    }

    public static String[] colnames(String x) {
        if (R_ENGINE == null) {
            return null;
        }
        REXP exp = R_ENGINE.eval("colnames(" + x + ")");
        if (exp != null) {
            return exp.asStringArray();
        }
        return null;
    }

    public static Vector colnamesVector(String x) {
        String[] cols = RUtils.colnames(x);
        Vector<String> colvec = new Vector<String>(cols.length);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            colvec.add(cols[i]);
        }
        return colvec;
    }

    public static Vector factors(String x) {
        String[] cols = RUtils.colnames(x);
        if (cols != null) {
            Vector<String> factors = new Vector<String>(cols.length);
            for (String col : cols) {
                boolean isFactor;
                String var = x + "$" + col;
                REXP exp = R_ENGINE.eval("as.character(is.factor(" + var + ") | is.logical(" + var + ") | is.character(" + var + "))");
                if (exp == null || !(isFactor = Boolean.valueOf(exp.asString()).booleanValue())) continue;
                factors.add(col);
            }
            return factors;
        }
        return null;
    }

    public static Vector nonFactors(String x) {
        String[] cols = RUtils.colnames(x);
        if (cols != null) {
            Vector<String> nonFactors = new Vector<String>(cols.length);
            for (String col : cols) {
                String var = x + "$" + col;
                boolean isFactor = Boolean.valueOf(R_ENGINE.eval("as.character(is.factor(" + var + ") | is.logical(" + var + ") | is.character(" + var + "))").asString());
                if (isFactor) continue;
                nonFactors.add(col);
            }
            return nonFactors;
        }
        return null;
    }

    public static String toString(Object[] obj, String separator, String quote) {
        if (obj != null) {
            return RUtils.toString(Arrays.asList(obj), separator, quote);
        }
        return "";
    }

    public static String toString(List list, String separator, String quote) {
        String str = "";
        if (separator == null) {
            separator = ",";
        }
        if (quote == null) {
            quote = "'";
        }
        if (list != null && list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object o = list.get(i);
                if (o == null) continue;
                str = o instanceof Integer || o instanceof Double ? str + o + separator : str + quote + o + quote + separator;
            }
            if (str.length() >= separator.length()) {
                str = str.substring(0, str.length() - separator.length());
            }
        }
        return str;
    }

    public static Vector evalAsVector(String cmd) {
        if (R_ENGINE == null) {
            return null;
        }
        REXP exp = R_ENGINE.eval("as.vector(" + cmd + ")");
        if (exp != null) {
            Vector<Object> v;
            int[] intArray = exp.asIntArray();
            if (intArray != null) {
                v = new Vector<Object>(intArray.length);
                int n = intArray.length;
                for (int i = 0; i < n; ++i) {
                    v.add(new Integer(intArray[i]));
                }
            } else {
                double[] dblArray = exp.asDoubleArray();
                if (dblArray != null) {
                    v = new Vector(dblArray.length);
                    int n = dblArray.length;
                    for (int i = 0; i < n; ++i) {
                        v.add(new Double(dblArray[i]));
                    }
                } else {
                    String[] strArray = exp.asStringArray();
                    if (strArray != null) {
                        v = new Vector(strArray.length);
                        int n = strArray.length;
                        for (int i = 0; i < n; ++i) {
                            v.add(strArray[i]);
                        }
                    } else {
                        String str = exp.asString();
                        if (str != null) {
                            v = new Vector(1);
                            v.add(str);
                        } else {
                            strArray = R_ENGINE.eval("as.character(" + cmd + ")").asStringArray();
                            v = new Vector(strArray.length);
                            int n = strArray.length;
                            for (int i = 0; i < n; ++i) {
                                v.add(strArray[i]);
                            }
                        }
                    }
                }
            }
            return v;
        }
        return null;
    }

    public static String evalAsString(String cmd) {
        if (R_ENGINE == null) {
            return null;
        }
        REXP exp = R_ENGINE.eval(cmd);
        if (exp != null) {
            return exp.asString();
        }
        return null;
    }
}

