% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treesourceClusterMethod.R
\name{treesource}
\alias{treesource}
\title{Mapping the tree clustering solution to a known source of variation underlying the forest}
\usage{
treesource(clusterforest, solution, source)
}
\arguments{
\item{clusterforest}{The clusterforest object}

\item{solution}{The solution}

\item{source}{A vector with the source for each tree in the forest}
}
\value{
\item{multiplot}{For each value of the source, a bar plot with the number of trees that belong to each cluster}
\item{heatmap}{A heatmap with for each value of the source, the number of trees that belong to each cluster}
}
\description{
A function that can be used to get insight into a clusterforest solution, in the case that there is a known
source of variation underlying the forest.
It visualizes the number of trees from each source that belong to each cluster.
}
\examples{
require(rpart)
data_Amphet <-drugs[,c ("Amphet","Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree",
"Consc", "Impul","Sensat")]
data_cocaine <-drugs[,c ("Coke","Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree",
                         "Consc", "Impul","Sensat")]
data_LSD <- drugs[,c ("LSD","Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree",
                         "Consc", "Impul","Sensat")]


#Function to draw a bootstrap sample from a dataset
DrawBoots <- function(dataset, i){
set.seed(2394 + i)
Boot <- dataset[sample(1:nrow(dataset), size = nrow(dataset), replace = TRUE),]
return(Boot)
}

#Function to grow a tree using rpart on a dataset
GrowTree <- function(x,y,BootsSample, minsplit = 40, minbucket = 20, maxdepth =3){

 controlrpart <- rpart.control(minsplit = minsplit, minbucket = minbucket, maxdepth = maxdepth,
 maxsurrogate = 0, maxcompete = 0)
 tree <- rpart(as.formula(paste(noquote(paste(y, "~")), noquote(paste(x, collapse="+")))),
  data = BootsSample, control = controlrpart)
 return(tree)
}

#Draw bootstrap samples and grow trees
BootsA<- lapply(1:3, function(k) DrawBoots(data_Amphet,k))
BootsC<- lapply(1:3, function(k) DrawBoots(data_cocaine,k))
BootsL<- lapply(1:3, function(k) DrawBoots(data_LSD,k))
Boots = c(BootsA,BootsC,BootsL)

TreesA <- lapply(1:3, function (i) GrowTree(x=c ("Age", "Gender", "Edu", "Neuro",
"Extr", "Open", "Agree","Consc", "Impul","Sensat"), y="Amphet", BootsA[[i]] ))
TreesC <- lapply(1:3, function (i) GrowTree(x=c ( "Age", "Gender", "Edu", "Neuro",
"Extr", "Open", "Agree", "Consc", "Impul","Sensat"), y="Coke", BootsC[[i]] ))
TreesL <- lapply(1:3, function (i) GrowTree(x=c ( "Age", "Gender", "Edu", "Neuro",
"Extr", "Open", "Agree", "Consc", "Impul","Sensat"), y="LSD", BootsL[[i]] ))
Trees=c(TreesA,TreesC,TreesL)

#Create forest object
myforest<- forest(drugs, Boots,Trees)

#calculate similarities
Simmatrix1<- treesimilarities(forest=myforest, m=1)

#Cluster
Clusters<- clusterforest(Simmatrix1, 1, 2)

#Link cluster result to known source of variation
treesource(Clusters, 2, rep(c("Amphet","Coke","LSD"),each=3) )
}
