% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constStrata.R
\name{constStrata}
\alias{constStrata}
\title{Strata creation}
\usage{
constStrata(
  data,
  strata,
  sep = ".",
  lex.order = FALSE,
  trace = TRUE,
  as.numeric = FALSE
)
}
\arguments{
\item{data}{[data.frame] dataset.}

\item{strata}{[character vector] A vector of the variables capturing the stratification factors.}

\item{sep}{[character] string to construct the new level labels by joining the constituent ones.}

\item{lex.order}{[logical] Should the order of factor concatenation be lexically ordered ?}

\item{trace}{[logical] Should the execution of the function be traced ?}

\item{as.numeric}{[logical] Should the strata be converted from factors to numeric?}
}
\value{
A \emph{factor vector} or a \emph{numeric vector}.
}
\description{
Create strata from several variables.
}
\details{
This function uses the \code{interaction} function from the \emph{base} package to form the strata.
}
\examples{
library(data.table)

library(survival) ## import veteran
  
# strata with two variables : celltype and karno
veteran$strata1 <- constStrata(veteran,c("celltype","karno"))
table(veteran$strata1)
  
# strata with three variables : celltype, karno and age dichotomized at 60 years
veteran$age60 <- veteran$age>60
veteran$age60 <- factor(veteran$age60,labels=c("<=60",">60")) # convert to factor with labels
veteran$strata2 <- constStrata(veteran,c("celltype","karno","age60"))
table(veteran$strata2) # factor strata variable 
  
veteran$strata2 <- constStrata(veteran,c("celltype","karno","age60"), as.numeric=TRUE)
table(veteran$strata2) # numeric strata variable

}
\author{
Brice Ozenne
}
\keyword{function}
\keyword{utilities}
