% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-model.tables.R
\docType{methods}
\name{S4BuyseTest-model.tables}
\alias{S4BuyseTest-model.tables}
\alias{model.tables,S4BuyseTest-method}
\title{Extract Summary for Class "S4BuyseTest"}
\usage{
\S4method{model.tables}{S4BuyseTest}(
  x,
  percentage = TRUE,
  statistic = NULL,
  conf.level = NULL,
  strata = NULL,
  columns = "summary",
  ...
)
}
\arguments{
\item{x}{output of \code{\link{BuyseTest}}}

\item{percentage}{[logical] Should the percentage of pairs of each type be displayed ? Otherwise the number of pairs is displayed.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"favorable"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
\code{"unfavorable"} displays the proportion in favor of the control.
Default value read from \code{BuyseTest.options()}.}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{strata}{[logical] should the strata-specific results be displayed or the results pooled across strata?
Can also be \code{NULL} to display both.}

\item{columns}{[character vector] subset of columns to be output (e.g. \code{"endpoint"}, \code{"favorable"}, ...).
Can also be \code{"summary"} or \code{"print"} to only select columns displayed in the summary or print. \code{NULL} will select all columns.}

\item{...}{arguments to be passed to \code{\link{S4BuyseTest-confint}}}
}
\description{
Extract a summary of the results from the \code{\link{BuyseTest}} function.
}
\examples{
library(data.table)

dt <- simBuyseTest(1e2, n.strata = 3)

 \dontrun{
 BT <- BuyseTest(treatment ~ TTE(eventtime, status = status) + Bin(toxicity), data=dt)
 }
 \dontshow{
 BT <- BuyseTest(treatment ~ TTE(eventtime, status = status) + Bin(toxicity), data=dt, n.resampling = 10, trace = 0)
 }
 model.tables(BT)
 model.tables(BT, percentage = FALSE)
 model.tables(BT, statistic = "winRatio")

}
\seealso{
\code{\link{BuyseTest}} for performing a generalized pairwise comparison. \cr
  \code{\link{S4BuyseTest-class}} for a presentation of the \code{S4BuyseTest} object. \cr
  \code{\link{S4BuyseTest-confint}} to output confidence interval and p-values in a matrix format.
}
\author{
Brice Ozenne
}
\keyword{methods}
