% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcIntegralSurv_cpp}
\alias{calcIntegralSurv_cpp}
\title{C++ Function Computing the Integral Terms for the Peron Method in the survival case.}
\usage{
calcIntegralSurv_cpp(
  survival,
  start,
  lastSurv,
  lastdSurv,
  returnDeriv,
  column,
  derivSurv,
  derivSurvD
)
}
\arguments{
\item{survival}{[matrix] Contains the jump times in the first column,
the survival in the other arm at times plus threshold in the second column,
and the jump in survival in the third column.}

\item{start}{[integer] time at which to start the integral.}

\item{lastSurv}{[numeric,>0] last survival value for the survival function in the second column.}

\item{lastdSurv}{[numeric,>0] last survival value for the survival function in the third column.}

\item{returnDeriv}{[logical] should the derivative regarding the survival parameters be return.}

\item{column}{[integer] column of \code{derivSurv} and \code{derivSurvD} to be filled.}

\item{derivSurv}{[matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival.}

\item{derivSurvD}{[matrix] matrix column filled of 0 whose number of rows is the number of parameters of the survival used to compute the jumps.}
}
\description{
Compute the integral with respect to the jump in survival for pairs where both outcomes are censored.
}
\author{
Brice Ozenne
}
\keyword{Cpp}
\keyword{function}
\keyword{internal}
