% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{sp_emission_factors_df}
\alias{sp_emission_factors_df}
\title{Emission Factors from the Environmental Agency of São Paulo (CETESB)}
\format{
A data frame with 288 observations and 10 variables:
\describe{
  \item{Age}{Vehicle age (integer)}
  \item{Year}{Reference year (integer)}
  \item{Pollutant}{Pollutant type (character)}
  \item{Proconve_LDV}{Proconve classification for light-duty vehicles (factor)}
  \item{t_Euro_LDV}{Temporal equivalence to EURO for light-duty vehicles (factor)}
  \item{Euro_LDV}{EURO standard classification for light-duty vehicles (factor)}
  \item{Proconve_HDV}{Proconve classification for heavy-duty vehicles (factor)}
  \item{Euro_HDV}{EURO standard classification for heavy-duty vehicles (factor)}
  \item{PC_G}{Emission factor (numeric)}
  \item{LT}{Lifetime or load factor (numeric)}
}
}
\source{
Data taken from the vein package version 1.1.3
}
\usage{
data(sp_emission_factors_df)
}
\description{
This dataset, sp_emission_factors_df, is a data frame containing emission factors from the Environmental
Agency of São Paulo (CETESB), including equivalencies with European (EURO) vehicle emission standards.
The dataset includes 288 observations and 10 variables, covering pollutants, vehicle age and type,
and classification systems such as Proconve and EURO for both light-duty and heavy-duty vehicles.
}
\details{
The dataset name has been kept as 'sp_emission_factors_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
BrazilDataAPI package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
