% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryBranchGLMVS.R
\name{plot.summary.BranchGLMVS}
\alias{plot.summary.BranchGLMVS}
\title{Plot Method for summary.BranchGLMVS}
\usage{
\method{plot}{summary.BranchGLMVS}(x, ptype = "metrics", marx = 7, ...)
}
\arguments{
\item{x}{a \code{summary.BranchGLMVS} object.}

\item{ptype}{the type of plot to produce, look at details for more explanation.}

\item{marx}{value used to determine how large to make margin of x-axis, this is 
only for ptype = "variables". If variable names are cut-off, consider increasing this, 
the default value is 7.}

\item{...}{arguments passed to the generic plot methods.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Plot Method for summary.BranchGLMVS
}
\details{
The different values for ptype are as follows
\itemize{
 \item "metrics" for a plot that displays the metric values ordered by rank
 \item "variables" for a plot that displays which variables are in each of the top models
}
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", bestmodels = 10, 
showprogress = FALSE)
VS

## Getting summary of the process
Summ <- summary(VS)
Summ

## Plotting the BIC of the best models
plot(Summ, type = "b")

## Plotting the variables in the best models
plot(Summ, ptype = "variables")

}
