% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{indsim}
\alias{indsim}
\title{Simulation time series data for individual}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 50 rows and 10 columns.
}
\usage{
indsim
}
\description{
A dataset containing values of 10 interested
variables over 50 periods.
}
\examples{
## Generated by the following R codes
set.seed(1000)
n = 50
p = 10
precision = diag(rep(2, p))        # generate precision matrix
for (i in 1 : (p - 1)){
  if (i <= 2 * p / 3) temp = 1
  if (i > 2 * p / 3) temp = 0.4
  precision[i, i + 1] = temp
  precision[i + 1, i] = temp
}
Sigma = solve(precision)           # generate covariance matrix
rho = 0.5
X = matrix(0, n, p)                # observed time series data
Epsilon = MASS::mvrnorm(n, rep(0, p), Sigma)
X[1, ] = Epsilon[1, ]
for (i in 2 : n){
  X[i, ] = rho * X[i - 1, ] + sqrt(1 - rho^2) * Epsilon[i, ]
}
indsim = X
}
\keyword{datasets}
