% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.test.R
\name{individual.test}
\alias{individual.test}
\title{Identify nonzero individual-level partial correlations}
\usage{
individual.test(indEst, alpha = 0.05, c0 = 0.1, MBT = 3000)
}
\arguments{
\item{indEst}{An \code{indEst} class object.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{c0}{threshold of the exceedance rate of the false discovery proportion (FDP),
default value is \code{0.1}.
The choice of \code{c0} depends on the empirical problem. A smaller value of \code{c0} will
reduce false positives, but it may also cost more false negatives.}

\item{MBT}{times of multiplier bootstrap, default value is \code{3000}.}
}
\value{
A \eqn{p*p} matrix with values 0 or 1.
If the j-th row and k-th column of the matrix is 1,
then the partial correlation coefficient between
the j-th variable and the k-th variable is identified to be nonzero.
}
\description{
Identify nonzero individual-level partial correlations in time series data
by controlling the exceedance rate of the false discovery proportion (FDP)
at \eqn{\alpha=0.05}, considering time dependence.
Input data \eqn{X} contains values of p interested
variables over n periods.
\cr
\cr
}
\examples{
## Quick example for the individual-level inference
data(indsim)
pc = individual.est(indsim)       # estimating partial correlation coefficients
Res = individual.test(pc)         # conducting hypothesis test

}
\references{
Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
\seealso{
\code{\link{population.test}} for making inferences on one individual in the population.
}
