% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_vboot.R
\name{vboot.lognet}
\alias{vboot.lognet}
\title{Internal bootstraping validation logistic glmnet model}
\usage{
\method{vboot}{lognet}(glmnet_fit, x, y, s, nfolds, B, cv_replicates,
  n_cores = max(1, parallel::detectCores() - 1))
}
\arguments{
\item{glmnet_fit}{Object from glmnet fit}

\item{x}{A matrix of the predictors, each row is an observation vector.}

\item{y}{A vector of response variable. Should be a factor with two levels}

\item{s}{Value of the penalty parameter "lambda" selected from the original 'cv.glmnet'}

\item{nfolds}{Number of folds for cross validation as in cv.glmnet}

\item{B}{Number of bootsrap samples}

\item{cv_replicates}{Number of replicates for the cross-validation step in 'cv.glmnet'}

\item{n_cores}{number of cores to use in parallel. Default detectCores()-1}
}
\description{
Validate glmnet logistic regression using bootstrap.
}
