% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BondVal.Yield.R
\name{BondVal.Yield}
\alias{BondVal.Yield}
\title{BondVal.Yield (calculation of YtM, AccrInt, DP, ModDUR, MacDUR and Conv)}
\usage{
BondVal.Yield(CP = as.numeric(NA), SETT = as.Date(NA),
  Em = as.Date(NA), Mat = as.Date(NA), CpY = as.numeric(NA),
  FIPD = as.Date(NA), LIPD = as.Date(NA), FIAD = as.Date(NA),
  RV = as.numeric(NA), Coup = as.numeric(NA), DCC = as.numeric(NA),
  EOM = as.numeric(NA), DateOrigin = as.Date("1970-01-01"),
  InputCheck = 1, FindEOM = FALSE, RegCF.equal = 0,
  SimpleLastPeriod = TRUE, Precision = .Machine$double.eps^0.75,
  Calc.Method = 1, AnnivDatesOutput = as.list(NA))
}
\arguments{
\item{CP}{The bond's clean price on \code{SETT}. (required)}

\item{SETT}{The settlement date. Date class object with format "\%Y-\%m-\%d". (required)}

\item{Em}{The bond's issue date. Date class object with format "\%Y-\%m-\%d". (required)}

\item{Mat}{So-called "maturity date" i.e. date on which the redemption value and the final interest
are paid. Date class object with format "\%Y-\%m-\%d". (required)}

\item{CpY}{Number of interest payments per year (non-negative integer; element of the set
\{0,1,2,3,4,6,12\}. Default: 2.}

\item{FIPD}{First interest payment date after \code{Em}. Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{LIPD}{Last interest payment date before \code{Mat}. Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{FIAD}{Date on which the interest accrual starts (so-called "dated date"). Date class object with format "\%Y-\%m-\%d". Default: \code{NA}.}

\item{RV}{The redemption value of the bond. Default: \code{100}.}

\item{Coup}{Nominal interest rate per year in percent. Default: \code{NA}.}

\item{DCC}{The day count convention the bond follows. Default: \code{NA}.
For a list of day count conventions currently implemented type \code{View(List.DCC)}.}

\item{EOM}{Boolean indicating whether the bond follows the End-of-Month rule. Default: \code{NA}.}

\item{DateOrigin}{Determines the starting point for the daycount in "Date" objects.
Default: "1970-01-01".}

\item{InputCheck}{If 1, the input variables are checked for the correct format. Default: 1.}

\item{FindEOM}{If \code{TRUE}, \code{EOM} is overridden by the value inferred from the data.
Default: \code{FALSE}.}

\item{RegCF.equal}{If 0, the amounts of regular cash flows are calculated according to the
stipulated \code{DCC}. Any other value forces all regular cash flows to be equal sized.
Default: 0.}

\item{SimpleLastPeriod}{Specifies the interest calculation method in the final coupon period. Default: \code{TRUE}.}

\item{Precision}{desired precision in YtM-calculation. Default: \code{.Machine$double.eps^0.75}.}

\item{Calc.Method}{If 1, discount powers are computed with the same DCC as accrued interest.
If 0, discount powers are computed with DCC=2. Default: 1.}

\item{AnnivDatesOutput}{A list containing the output of the function AnnivDates. Default: \code{NA}.}
}
\value{
\describe{
    \item{CP}{The bond's clean price.}
    \item{AccrInt}{The amount of accrued interest.}
    \item{DP}{The bond's dirty price.}
    \item{ytm.p.a.}{Annualized yield to maturity.}
    \item{ModDUR.inYears}{Modified duration in years.}
    \item{MacDUR.inYears}{MacAulay duration in years.}
    \item{Conv.inYears}{Convexity in years.}
    \item{ModDUR.inPeriods}{Modified duration in periods.}
    \item{MacDUR.inPeriods}{MacAulay duration in periods.}
    \item{Conv.inPeriods}{Convexity in periods.}
    \item{tau}{Relative Position of the settlement date in regular periods.}
  }
}
\description{
\bold{BondVal.Yield} returns a bond's yield to maturity given its clean price.
}
\details{
\bold{BondVal.Yield} uses the function \bold{AnnivDates} to analyze the bond
and computes the yield to maturity, the accrued interest, the dirty price and the sensitivity
measures modified duration (ModDUR), MacAulay duration (MacDUR) and convexity according
to the methodology presented in Djatschenko (2018). The yield to maturity is determined
numerically using the Newton-Raphson method.
}
\examples{
data(PanelSomeBonds2016)
randombond<-sample(c(1:length(which(!(duplicated(PanelSomeBonds2016$ID.No))))),1)
df.randombond<-PanelSomeBonds2016[which(PanelSomeBonds2016$ID.No==randombond),]

PreAnalysis.randombond<-suppressWarnings(AnnivDates(
  unlist(df.randombond[
           1,c('Issue.Date','Mat.Date','CpY.Input','FIPD.Input','LIPD.Input',
               'FIAD.Input','RV.Input','Coup.Input','DCC.Input','EOM.Input')],
         use.names=FALSE)))

system.time(
  for (i in c(1:nrow(df.randombond))) {
BondVal.Yield.Output<-suppressWarnings(BondVal.Yield(
      unlist(df.randombond[i,c('CP.Input','TradeDate','Issue.Date','Mat.Date',
                'CpY.Input','FIPD.Input','LIPD.Input','FIAD.Input','RV.Input',
                'Coup.Input','DCC.Input','EOM.Input')],use.names=FALSE),
      AnnivDatesOutput=PreAnalysis.randombond))
    df.randombond$YtM.Out[i]<-BondVal.Yield.Output$ytm.p.a.
  }
)
plot(seq(1,nrow(df.randombond),by=1),df.randombond$YtM.Out,"l")

}
\references{
\enumerate{
  \item{Djatschenko, Wadim, The Nitty Gritty of Bond Valuation: A Generalized Methodology for Fixed Coupon Bond Analysis Allowing for Irregular Periods and Various Day Count Conventions (November 5, 2018). Available at SSRN: https://ssrn.com/abstract=3205167.}
}
}
