% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{bland.altman.PEFR}
\alias{bland.altman.PEFR}
\title{PEFR Data from Bland JM and Altman DG 1986}
\format{\preformatted{'data.frame':	17 obs. of  4 variables:
 $ bigger.first  : num  494 395 516 434 476 557 413 442 650 433 ...
 $ bigger.second : num  490 397 512 401 470 611 415 431 638 429 ...
 $ smaller.first : num  512 430 520 428 500 600 364 380 658 445 ...
 $ smaller.second: num  525 415 508 444 500 625 460 390 642 432 ...
}}
\usage{
bland.altman.PEFR
}
\description{
Peak expiratory flow data from 17 members of Bland's family, taken with two
different instruments, each twice. This data is for explanatory use only.
Columns 1 and 2 were measured with the "Wright" peak flow meter, columns 3
and 4 with the "Mini Wright" peak flow meter.
These are the data behind fig. 1, fig. 2 and fig. 6 of the original paper and
these can be easily reconstructed
}
\examples{
# this is what fig. 1. would have looked like in R:
x <- bland.altman.PEFR[["bigger.first"]]
y <- bland.altman.PEFR[["smaller.first"]]
plot(x,y, xlab="PEFR by large meter",ylab="PEFR by mini meter",
     xlim=c(0,800), ylim=c(0,800))
abline(0,1)
}
\keyword{datasets}

