% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/478-extractDrugKR.R
\name{extrDrugKRComplete}
\alias{extrDrugKRComplete}
\title{Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Complete Format)}
\usage{
extrDrugKRComplete(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule, 
the columns represent the fingerprints.
}
\description{
Calculate the KR (Klekota and Roth) Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the 4860 bit fingerprint defined by Klekota and Roth.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugKRComplete(mol)
dim(fp)

}
\seealso{
\link{extrDrugKR}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugKRComplete}
