% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgma.R
\name{upgma}
\alias{upgma}
\title{Draws a hierarchical clustering tree (UPGMA).}
\usage{
upgma(
  x,
  bts = 10,
  size = 0.55,
  lab_size = 0.55,
  method = "binary",
  hclust = "average",
  fromFile = FALSE
)
}
\arguments{
\item{x}{Consolidated binarx matrix.}

\item{bts}{Bootstrap replications. Set to 10 by default.}

\item{size}{Size of plot. Set to 0.55 by default.}

\item{lab_size}{Size of label text. Set to 0.55 by default.}

\item{method}{Distance method. Set to 'binary' (=Jaccard distance) by default.}

\item{hclust}{Clustering method. Set to 'average' (=UPGMA) by default}

\item{fromFile}{Indicates whether the binary data used by the function has been consolidated by BinMat, or whether it comes from the user's own file. Set to FALSE by default (in the assumption that the data has been consolidated by BinMat, and that that object is being passed to the function).}
}
\value{
UPGMA tree
}
\description{
Creates a UPGMA hierarchical clustering tree, with a specified number of bootstrap repetitions.
}
\examples{
data(BinMatInput_reps)
mat = BinMatInput_reps
cons = consolidate(mat)
clust = upgma(cons)

}
