% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdSolve}
\alias{bdSolve}
\title{Solve matrix equations}
\usage{
bdSolve(A, B)
}
\arguments{
\item{A}{numerical matrix.}

\item{B}{numerical matrix.}
}
\value{
X numerical matrix.
}
\description{
This function solve matrix equations 
 \code{A * X = B } 
where A is an N-by-N matrix and X and B are N-by-NRHS matrices.
}
\examples{

library(BigDataStatMeth)

n <- 500
m <- 500

# R Object

A <- matrix(runif(n*m), nrow = n, ncol = m)
B <- matrix(runif(n), nrow = n)
AS <- A\%*\%t(A)
      
X <- bdSolve(A, B)
XR <- solve(A,B)
      
all.equal(X, XR, check.attributes=FALSE)
  
}
