% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{getSpace}
\alias{getSpace}
\title{Extracting scorespace from MCMC object}
\usage{
getSpace(x)
}
\arguments{
\item{x}{object of class 'orderMCMC','partitionMCMC' or 'iterativeMCMC'}
}
\value{
an object of class 'scorespace' or an adjacency binary matrix corresponding to a search space last used in MCMC
}
\description{
This function extracts an object of class 'scorespace'
from the result of the MCMC run when the parameter 'scoreout' was set to TRUE; otherwise extracts
only adjacency matrix of the final search space without the score tables.
}
\examples{
myscore<-scoreparameters("bge", Boston)
\dontrun{
itfit<-learnBN(myscore,algorithm="orderIter",scoreout=TRUE)
itspace<-getSpace(itfit)
}
}
