% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidag2coda.R
\name{bidag2codalist}
\alias{bidag2codalist}
\title{Converting multiple BiDAG chains to mcmc.list}
\usage{
bidag2codalist(
  MCMClist,
  edges = FALSE,
  pdag = TRUE,
  p = 0.1,
  burnin = 0.2,
  window = 10,
  cumulative = FALSE
)
}
\arguments{
\item{MCMClist}{a list of objects of classes \code{orderMCMC} or \code{partitionMCMC}}

\item{edges}{logical, when FALSE (default), then only DAG score traces are extracted from each element of MCMClist and all other parameters are ignored; when TRUE, a trace of posterior probabilities is computed for every edge resulting in a maximum of n*n trace vectors, where n is the number of nodes in the network}

\item{pdag}{logical, when edges=TRUE, defines is the DAGs ar converted to CPDAGs prior to computing posterior probabilities; ignored otherwise}

\item{p}{numeric, between 0 and 1; defines the minimum probability for including posterior traces in the returned objects (for probabilities close to 0, PRSF diagnostics maybe too conservative; the threshold above 0 is recommended)}

\item{burnin}{numeric between \code{0} and \code{1}, indicates the percentage of the samples which will be discarded as 'burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}

\item{window}{integer, defines a number of DAG samples for averaging and computing edges' posterior probabilities; ignored when edges=FALSE}

\item{cumulative}{logical, indicates is posterior probabilities should be calculated based on a cumulative sample of DAGs, where 25\% of first samples are discarded}
}
\value{
Object of class \code{mcmc.list} from the package \pkg{coda}
}
\description{
This function converts a list of objects of classes
'orderMCMC' and 'partitionMCMC' to an object of class 'mcmc.list'. This object can
be further used for convergence and mixing diagnostics implemented in the R-package coda.
}
\examples{
\dontrun{
scoreBoston<-scoreparameters("bge",Boston)
ordershort<-list()
#run very short chains -> convergence issues
ordershort[[1]] <- sampleBN(scoreBoston, algorithm = "order", iterations=2000)
ordershort[[2]] <- sampleBN(scoreBoston, algorithm = "order", iterations=2000)
codashort_edges<-bidag2codalist(ordershort,edges=TRUE,pdag=TRUE,p=0.05,burnin=0.2,window=10)
gd_short<-gelman.diag(codashort_edges, transform=FALSE, autoburnin=FALSE, multivariate=FALSE)
length(which(gd_short$psrf[,1]>1.1))/(length(gd_short$psrf[,1]))
}
}
\references{
Robert J. B. Goudie and Sach Mukherjee (2016). A Gibbs Sampler for Learning DAGs. J Mach Learn Res. 2016 Apr; 17(30): 1–39.
}
\author{
Polina Suter
}
