% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initpar.R
\name{scoreparameters}
\alias{scoreparameters}
\title{Initialising score object}
\usage{
scoreparameters(n, scoretype = c("bge", "bde"), data, weightvector = NULL,
  bgepar = list(am = 1, aw = NULL), bdepar = list(edgepf = 2, chi = 0.5))
}
\arguments{
\item{n}{number of nodes (variables) in the Bayesian network}

\item{scoretype}{the score to be used to assess the DAG structure: "bde" for binary data, "bge" for Gaussian data}

\item{data}{the data matrix with n columns (the number of variables) and a number of rows equal to the number of observations}

\item{weightvector}{(optional) a numerical vector of positive values representing the weight of each observation; should be NULL(default) for non-weighted data}

\item{bgepar}{a list which contains parameters for BGe score:
\itemize{
\item am (optional) a positive numerical value, 1 by default
\item aw (optional) a positive numerical value should be more than \code{n+1}, \code{n+am+1} by default
}}

\item{bdepar}{a list which contains parameters for BDe score:
\itemize{
\item chi (optional) a positive number of prior pseudo counts used by the BDe score, 0.5 by default
\item edgepf (optional) a positive numerical value providing the edge penalization factor to be combined with the BDe score, 2 by default
}}
}
\value{
an object of class \code{scoreparameters}, which includes all necessary information for calculating the BDe/BGe score
}
\description{
This function returns an object of class scoreparameters containing the data and parameters needed for calculation of the BDe/BGe score.
}
\examples{
myDAG<-pcalg::randomDAG(20, prob=0.15, lB = 0.4, uB = 2) 
myData<-pcalg::rmvDAG(200, myDAG) 
myScore<-scoreparameters(20, "bge", myData)
}
\references{
Geiger D and Heckerman D (2002). Parameter priors for directed acyclic graphical models and the characterization of several probability distributions. The Annals of Statistics 30, 1412-1440.

Kuipers J, Moffa G and Heckerman D (2014). Addendum on the scoring of Gaussian acyclic graphical models. The Annals of Statistics 42, 1689-1691.

Heckerman D and Geiger D (1995). Learning Bayesian networks: A unification for discrete and Gaussian domains. In Eleventh Conference on Uncertainty in Artificial Intelligence, pages 274-284.

Scutari M (2016). An Empirical-Bayes Score for Discrete Bayesian Networks. Journal of Machine Learning Research 52, 438-448
}
