% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{adjacency2dag}
\alias{adjacency2dag}
\title{Deriving a graph from an adjacancy matrix}
\usage{
adjacency2dag(adj, nodes = NULL)
}
\arguments{
\item{adj}{square adjacency matrix with elements in \code{\{0,1\}}, representing a graph}

\item{nodes}{(optional) labels of the nodes, \code{c(1:n)} are used by default}
}
\value{
object of class \code{\link[graph]{graphNEL}} (package `graph'); if element \code{adj[i,j]} equals \code{1}, then there is a directed edge from node \code{i} to node \code{j} in the graph, and no edge otherwise
}
\description{
This function derives a graph object corresponding to an adjacency matrix
}
\examples{
adj<-matrix(rep(0,16),nrow=4)
adj[2,1]<-1
adj[1,4]<-1
adjacency2dag(adj)
}
