% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/food.R
\docType{data}
\name{food}
\alias{food}
\alias{food_max}
\alias{food_mini}
\alias{food_all}
\title{The food data from Rijksinstituut voor Volksgezondheid en Milieu}
\format{
data frame: 2207 obs. of 9 variables
}
\description{
The Dutch institute Rijksinstituut voor Volksgezondheid en Milieu
has compiled a database with ingredient information on more than
2,200 food products. The data in this package is only a processed
fraction of the huge and very interesting NEVO database available
at \url{https://www.rivm.nl/documenten/nevo-online-versie}.
}
\details{
The preprocessed data can be used to reproduce the charts
from the book Wyrkesy od kuchni (Charts from the Kitchen)
\url{https://github.com/BetaAndBit/Wykresy}
}
\examples{
library("ggplot2")

head(food)

\donttest{
library("ggthemes")
ggplot(data = food, aes(x = Energia)) +
   geom_histogram(color = "white") +
   facet_wrap(~Grupa) +
   labs(title = "Wartość energetyczna produktów", subtitle = "na 100 g",
      x = "Wartość energetyczna", y = "Liczba") +
   theme_economist()

ggplot(data = food_mini, aes(x = Energia)) +
   geom_histogram(color = "white") +
   facet_wrap(~Grupa) +
   labs(title = "Wartość energetyczna produktów", subtitle = "na 100 g",
      x = "Wartość energetyczna", y = "Liczba") +
   theme_economist()

ggplot(data = food, aes(x = Białko, y = Tłuszcze,
   color = Grupa, size = Energia)) +
     geom_point() +
   scale_color_brewer(type = "qual", palette = "Dark2") +
 labs(title = "Udział białka i tłuszczów", subtitle = "na 100 g",
      y = "Tłuszcze [g]", x = "Białko [g]") +
      theme_gdocs()

ggplot(data = food, aes(x = Grupa, y = Energia)) +
  geom_rug(sides = "l") +
  geom_violin(scale = "width", aes(fill = Grupa)) +
  geom_text(data = food_max, aes(label =  Nazwa),
          hjust = 0, vjust = 0, color = "blue4") +
  geom_boxplot(width = 0.2, coef = 100) +
  coord_flip() +
  labs(title = "Rozkład wartości energetycznej", subtitle = "na 100 g") +
  theme_gdocs() + theme(legend.position = "none")

}

}
\keyword{datasets}
